using Nemerle.IO;
using System.Environment;
using Nemerle.Compiler;

macro hmm ()  {
 def t = "S";
  <[  $(t:string)  ]>
}


macro time_syn(f)
syntax ("tim" ,f)
{
	if (Options.IsConstantDefined("timing"))
	<[  
		def s = System.Environment.TickCount;
		def r = $(f);
		print("$(System.Environment.TickCount - s)\n");
	r
	]> else 
	<[
		$(f)
	]>
}

macro fib (i : int)
{
	when (i==0) Message.Error ("fib are numerated from 1");
	
	def f(n : int) : int
	{
		| n when (3 > n) => 1
		| n => f(n-1) + f(n-2)
	}

	<[  $(f(i):int)  ]>	
}

macro easter_egg (fox, _jumped, _over, _lazy, dog) 
syntax ("Quick", fox, _jumped, _over, _lazy, dog ) {
<[
  System.Console.WriteLine($((" "+fox.ToString()):string));
  System.Console.WriteLine("------");
  System.Console.WriteLine($((" "+dog.ToString()):string));
]>
}


public interface ISerializable {
  Serialize () : void;
}

[Nemerle.MacroUsage (Nemerle.MacroPhase.BeforeInheritance, Nemerle.MacroTargets.Class,
                     Inherited = true)]
macro Serializable (t : TypeBuilder)
{
	t.AddImplementedInterface (<[ ISerializable ]>)
}

[Nemerle.MacroUsage (Nemerle.MacroPhase.WithTypedMembers, Nemerle.MacroTargets.Class,
                     Inherited = true)]
macro Serializable (t : TypeBuilder)
{
	def fields = t.GetFields (BindingFlags.Instance | BindingFlags.Public |
				  BindingFlags.NonPublic | BindingFlags.DeclaredOnly);
 
	mutable serializers = [];
 
	foreach (x : IField in fields)
	{
		def nm = Macros.UseSiteSymbol (x.Name);
		serializers = <[
			printf ("<%s>", $(x.Name : string));
			System.Console.Write ($(nm : name));
			printf ("</%s>\n", $(x.Name : string));
				]> :: serializers;
	}
	t.Define (<[ decl: public Serialize () : void
                     implements ISerializable.Serialize { .. $serializers }
           ]>);
}

